/*
 * Decompiled with CFR 0.152.
 */
package tankowar;

import java.io.BufferedOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.StringTokenizer;
import tankowar.OwnServerAdapter;
import tankowar.TimedMessageQueue;
import tankowar.tankgame;

class tankgameServer
extends tankgame {
    String adminpw = "admin";
    byte[] bulletmsg;
    boolean gamemodeChanged = false;
    boolean[] isAdmin;
    boolean mapChanged = false;
    static int maxClients = 6;
    byte[] msg;
    boolean[] nameChanged = new boolean[6];
    boolean[] pointed;
    ServerSocket serverSocket = null;
    tankgameServerPoster serverposter;
    tankgameServerThread[] th;
    int[] time;

    public tankgameServer(String mpname) {
        this.isAdmin = new boolean[6];
        this.time = new int[6];
        this.pointed = new boolean[6];
        this.msg = new byte[8];
        this.bulletmsg = new byte[7];
        this.mapname = mpname != null ? mpname : "quick";
        this.map.makeMap(this.mapname);
        this.messageBox = new TimedMessageQueue(5, 3);
        this.th = new tankgameServerThread[maxClients];
        this.deaths = new int[maxClients];
        this.kills = new int[maxClients];
        this.points = new int[maxClients];
        this.gamemode = 0;
        boolean listening = true;
        try {
            this.serverSocket = new ServerSocket(1111);
        }
        catch (Exception e) {
            System.err.println("Could not listen on port: 1111.");
            System.exit(1);
        }
        int i = 0;
        while (i < 6) {
            this.nameChanged[i] = false;
            ++i;
        }
        this.setTitle("tankGameServer " + tankgame.VERSION + " - ObserverMode");
        System.out.println("started server. maxPlayers = " + maxClients);
        this.addWindowListener(new OwnServerAdapter(this));
        this.serverposter = new tankgameServerPoster();
        this.serverposter.start();
        while (listening) {
            do {
                int free;
                if ((free = this.freeThread()) == -1) continue;
                try {
                    this.th[free] = new tankgameServerThread(this.serverSocket.accept(), free);
                    this.th[free].start();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } while (tankgame.numTanks < maxClients);
        }
    }

    private int freeThread() {
        int result = 0;
        while (result < maxClients) {
            if (this.th[result] == null || !this.th[result].running) {
                return result;
            }
            ++result;
        }
        return -1;
    }

    public static void main(String[] args) {
        tankgame.numTanks = 0;
        if (args.length > 0) {
            maxClients = Integer.parseInt(args[0]);
        }
        if (maxClients > 6) {
            maxClients = 6;
        }
        if (maxClients < 2) {
            maxClients = 2;
        }
        String mpname = null;
        if (args.length > 1) {
            mpname = args[1];
        }
        System.out.println(" trying to start server.......");
        new tankgameServer(mpname);
    }

    private void sendTankinfo(int tankNum, OutputStream output) throws Exception {
        int nbrBullets;
        int misc = 0;
        boolean bullet = false;
        int xpos = (int)this.tank[tankNum].x;
        int ypos = (int)this.tank[tankNum].y;
        this.msg[1] = (byte)(xpos >> 8);
        this.msg[3] = (byte)(ypos >> 8);
        int dir = (int)(this.tank[tankNum].direction * 1000.0);
        this.msg[5] = (byte)(dir >> 8);
        this.msg[0] = (byte)tankNum;
        this.msg[2] = (byte)xpos;
        this.msg[4] = (byte)ypos;
        this.msg[6] = (byte)dir;
        if (this.tank[tankNum].alive) {
            misc |= 1;
        }
        if ((nbrBullets = this.tank[tankNum].getNbrBullets()) > 0) {
            misc |= 2;
            bullet = true;
        }
        if (this.tank[tankNum].kill) {
            misc |= 4;
        }
        if (this.nameChanged[tankNum]) {
            misc |= 8;
        }
        if (this.pointed[tankNum]) {
            misc |= 0x10;
        }
        this.msg[7] = (byte)misc;
        output.write(this.msg);
        if (bullet) {
            output.write(nbrBullets);
            int i = 0;
            while (i < 6) {
                if (this.tank[tankNum].bullet[i] != null && this.tank[tankNum].bullet[i].running) {
                    xpos = (int)this.tank[tankNum].bullet[i].x;
                    this.bulletmsg[0] = (byte)(xpos >> 8);
                    ypos = (int)this.tank[tankNum].bullet[i].y;
                    this.bulletmsg[2] = (byte)(ypos >> 8);
                    dir = (int)(this.tank[tankNum].bullet[i].sv.angle * 1000.0);
                    this.bulletmsg[4] = (byte)(dir >> 8);
                    this.bulletmsg[1] = (byte)xpos;
                    this.bulletmsg[3] = (byte)ypos;
                    this.bulletmsg[5] = (byte)dir;
                    this.bulletmsg[6] = (byte)i;
                    output.write(this.bulletmsg);
                }
                ++i;
            }
        }
        if (this.nameChanged[tankNum]) {
            output.write(this.tankname[tankNum].length());
            output.write(this.tankname[tankNum].getBytes());
        }
    }

    class tankgameServerThread
    extends Thread {
        int change;
        InputStream input;
        Socket mySocket;
        int myTank;
        BufferedOutputStream output;
        boolean running;

        public tankgameServerThread(Socket socket, int tankNbr) {
            this.mySocket = socket;
            ++tankgame.numTanks;
            try {
                this.myTank = tankNbr;
                if (this.myTank == -1) {
                    this.running = false;
                    return;
                }
                this.mySocket.setTcpNoDelay(true);
                this.output = new BufferedOutputStream(socket.getOutputStream());
                this.input = socket.getInputStream();
                this.sendGamemode();
                this.negotiateMap();
                this.output.write(this.myTank);
                this.output.write(tankgame.numTanks);
                this.output.write(maxClients);
                System.out.println(" player" + this.myTank + " entered the game");
                System.out.println("currently " + tankgame.numTanks + " people playing");
                tankgameServer.this.tank[this.myTank] = new tankgame.Tank();
                tankgameServer.this.tank[this.myTank].setColorCode(this.myTank);
                tankgameServer.this.deaths[this.myTank] = 0;
                tankgameServer.this.kills[this.myTank] = 0;
                tankgameServer.this.points[this.myTank] = 0;
                tankgameServer.this.isAdmin[this.myTank] = false;
                tankgameServer.this.pointed[this.myTank] = false;
                tankgameServer.this.time[this.myTank] = 0;
                this.running = true;
                int i = 0;
                while (i < 6) {
                    if (tankgameServer.this.tank[i] != null && tankgameServer.this.tank[i].running) {
                        if (i != this.myTank) {
                            tankgameServer.this.nameChanged[i] = true;
                        }
                        tankgameServer.this.sendTankinfo(i, this.output);
                    }
                    ++i;
                }
                this.output.flush();
                tankgameServer.this.repaint();
            }
            catch (Exception e) {
                e.printStackTrace();
                System.exit(1);
            }
        }

        private void changeMap(String mapname) {
            if (!tankgameServer.this.map.makeMap(mapname)) {
                System.out.println("map not found");
                return;
            }
            tankgameServer.this.mapChanged = true;
        }

        private void changeMode(String mode) {
            if (mode.equalsIgnoreCase("ctf")) {
                tankgameServer.this.gamemode = 1;
                tankgameServer.this.hill = null;
                tankgameServer.this.flag = new tankgame.Flag();
            } else if (mode.equalsIgnoreCase("dm")) {
                tankgameServer.this.gamemode = 0;
                tankgameServer.this.hill = null;
                tankgameServer.this.flag = null;
            } else if (mode.equalsIgnoreCase("koth")) {
                tankgameServer.this.gamemode = 2;
                tankgameServer.this.flag = null;
                tankgameServer.this.hill = new tankgame.Hill();
            } else {
                System.out.println(" mode " + mode + " unkown");
                return;
            }
            tankgameServer.this.gamemodeChanged = true;
        }

        private void negotiateMap() throws Exception {
            System.out.println(" sending map '" + tankgameServer.this.map.name + "'");
            this.output.write(tankgameServer.this.map.name.length());
            this.output.write(tankgameServer.this.map.name.getBytes());
            this.output.flush();
            if (this.input.read() == 0) {
                return;
            }
            System.out.println(" sending map to client");
            int y = 0;
            while (y < 15) {
                int x = 0;
                while (x < 20) {
                    this.output.write((byte)tankgameServer.this.map.map[x][y]);
                    ++x;
                }
                ++y;
            }
            this.output.flush();
        }

        private void parseConsoleMessage(String message, int clientNbr) {
            StringTokenizer tokenizer = new StringTokenizer(message);
            String command = tokenizer.nextToken();
            if (command.equalsIgnoreCase("admin")) {
                if (tokenizer.nextToken().equalsIgnoreCase(tankgameServer.this.adminpw)) {
                    tankgameServer.this.isAdmin[clientNbr] = true;
                }
            } else if (command.equalsIgnoreCase("map")) {
                this.changeMap(tokenizer.nextToken());
            } else if (command.equalsIgnoreCase("mode")) {
                this.changeMode(tokenizer.nextToken());
            }
        }

        private void receiveChatMessage(String message, int clientNbr) {
            tankgameServer.this.messageBox.add("[" + tankgameServer.this.tankname[clientNbr] + "]: " + message);
        }

        public void run() {
            while (this.running) {
                try {
                    this.change = this.input.read();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                switch (this.change) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        tankgameServer.this.tank[this.myTank].move(2.5);
                        break;
                    }
                    case 2: {
                        tankgameServer.this.tank[this.myTank].move(-1.0);
                        break;
                    }
                    case 3: {
                        tankgameServer.this.tank[this.myTank].turn(0.2);
                        break;
                    }
                    case 4: {
                        tankgameServer.this.tank[this.myTank].turn(-0.2);
                        break;
                    }
                    case 5: {
                        tankgameServer.this.tank[this.myTank].fire();
                        break;
                    }
                    case 11: {
                        if (tankgameServer.this.tank[this.myTank].alive) break;
                        tankgameServer.this.tank[this.myTank].reborn();
                        break;
                    }
                    case 13: {
                        try {
                            int length = this.input.read();
                            byte[] namebuf = new byte[length];
                            this.input.read(namebuf);
                            tankgameServer.this.tankname[this.myTank] = new String(namebuf);
                            tankgameServer.this.nameChanged[this.myTank] = true;
                            System.out.println(" #" + this.myTank + " switched name to " + tankgameServer.this.tankname[this.myTank]);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        break;
                    }
                    case 15: {
                        String msg;
                        try {
                            int length = this.input.read();
                            byte[] namebuf = new byte[length];
                            this.input.read(namebuf);
                            msg = new String(namebuf);
                            this.parseConsoleMessage(msg, this.myTank);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        break;
                    }
                    case 16: {
                        String msg;
                        try {
                            int length = this.input.read();
                            byte[] namebuf = new byte[length];
                            this.input.read(namebuf);
                            msg = new String(namebuf);
                            this.receiveChatMessage(msg, this.myTank);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        break;
                    }
                    case 128: {
                        System.out.println(" sending map to client");
                        try {
                            int y = 0;
                            while (y < 15) {
                                int x = 0;
                                while (x < 20) {
                                    this.output.write((byte)tankgameServer.this.map.map[x][y]);
                                    ++x;
                                }
                                ++y;
                            }
                            this.output.flush();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        break;
                    }
                    case 255: {
                        System.out.println(tankgameServer.this.tankname[this.myTank] + " has left the game");
                        this.running = false;
                        try {
                            this.mySocket.close();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        tankgameServer.this.tank[this.myTank].destroy();
                        tankgameServer.this.tank[this.myTank].running = false;
                        tankgameServer.this.tank[this.myTank] = null;
                        System.out.println("currently " + --tankgame.numTanks + " people playing");
                    }
                }
                tankgameServer.this.repaint();
            }
        }

        private void sendGamemode() throws Exception {
            this.output.write(tankgameServer.this.gamemode);
            this.output.flush();
            if (tankgameServer.this.gamemode == 2) {
                byte[] modeMsg = new byte[]{(byte)(tankgameServer.this.hill.x >> 8), (byte)tankgameServer.this.hill.x, (byte)(tankgameServer.this.hill.y >> 8), (byte)tankgameServer.this.hill.y};
                this.output.write(modeMsg);
                this.output.flush();
            } else if (tankgameServer.this.gamemode == 1) {
                byte[] modeMsg = new byte[]{(byte)(tankgameServer.this.flag.x >> 8), (byte)tankgameServer.this.flag.x, (byte)(tankgameServer.this.flag.y >> 8), (byte)tankgameServer.this.flag.y, -1};
                this.output.write(modeMsg);
                this.output.flush();
            }
        }
    }

    class tankgameServerPoster
    extends Thread {
        String[] allmsg;
        OutputStream out;
        boolean running = true;

        public void run() {
            int i;
            int flagOwner = -1;
            byte[] flagmsg = new byte[5];
            while (this.running) {
                int i2;
                if (tankgameServer.this.gamemode == 2) {
                    i = 0;
                    while (i < 6) {
                        if (tankgameServer.this.th[i] != null && tankgameServer.this.th[i].running && tankgameServer.this.tank[i].alive) {
                            if (tankgameServer.this.hill.inside(tankgameServer.this.tank[i])) {
                                int n = i;
                                tankgameServer.this.time[n] = tankgameServer.this.time[n] + 1;
                            } else {
                                tankgameServer.this.time[i] = 0;
                            }
                            if (tankgameServer.this.time[i] == 50) {
                                int n = i;
                                tankgameServer.this.points[n] = tankgameServer.this.points[n] + 1;
                                tankgameServer.this.pointed[i] = true;
                                tankgameServer.this.time[i] = 0;
                            }
                        }
                        ++i;
                    }
                } else if (tankgameServer.this.gamemode == 1) {
                    i = 0;
                    while (i < 6) {
                        if (tankgameServer.this.th[i] != null && tankgameServer.this.th[i].running && tankgameServer.this.tank[i].alive) {
                            if (tankgameServer.this.flag.checkOwner(tankgameServer.this.tank[i])) {
                                int n = i;
                                tankgameServer.this.time[n] = tankgameServer.this.time[n] + 1;
                                flagOwner = i;
                            } else {
                                tankgameServer.this.time[i] = 0;
                            }
                            if (tankgameServer.this.time[i] == 50) {
                                int n = i;
                                tankgameServer.this.points[n] = tankgameServer.this.points[n] + 1;
                                tankgameServer.this.pointed[i] = true;
                                tankgameServer.this.time[i] = 0;
                            }
                        }
                        ++i;
                    }
                    if (tankgameServer.this.sendFlag) {
                        try {
                            i2 = 0;
                            while (i2 < 6) {
                                if (tankgameServer.this.th[i2] != null && tankgameServer.this.th[i2].running && tankgameServer.this.tank[i2].alive) {
                                    tankgameServer.this.th[i2].output.write(15);
                                    tankgameServer.this.th[i2].output.flush();
                                    flagmsg[0] = (byte)(tankgameServer.this.flag.x >> 8);
                                    flagmsg[1] = (byte)tankgameServer.this.flag.x;
                                    flagmsg[2] = (byte)(tankgameServer.this.flag.y >> 8);
                                    flagmsg[3] = (byte)tankgameServer.this.flag.y;
                                    flagmsg[4] = tankgameServer.this.flag.owner == null ? -1 : (byte)flagOwner;
                                    tankgameServer.this.th[i2].output.write(flagmsg);
                                    tankgameServer.this.th[i2].output.flush();
                                }
                                ++i2;
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        tankgameServer.this.sendFlag = false;
                    }
                }
                if (tankgameServer.this.gamemodeChanged) {
                    try {
                        i = 0;
                        while (i < 6) {
                            if (tankgameServer.this.th[i] != null && tankgameServer.this.th[i].running) {
                                tankgameServer.this.th[i].output.write(14);
                                tankgameServer.this.th[i].output.flush();
                                tankgameServer.this.th[i].sendGamemode();
                            }
                            ++i;
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    tankgameServer.this.gamemodeChanged = false;
                }
                if (tankgameServer.this.mapChanged) {
                    try {
                        int i3 = 0;
                        while (i3 < 6) {
                            if (tankgameServer.this.th[i3] != null && tankgameServer.this.th[i3].running) {
                                tankgameServer.this.th[i3].output.write(13);
                                tankgameServer.this.th[i3].output.flush();
                                System.out.println(" sending map '" + tankgameServer.this.map.name + "'");
                                tankgameServer.this.th[i3].output.write(tankgameServer.this.map.name.length());
                                tankgameServer.this.th[i3].output.write(tankgameServer.this.map.name.getBytes());
                                tankgameServer.this.th[i3].output.flush();
                                tankgameServer.this.tank[i3].reborn();
                            }
                            ++i3;
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    tankgameServer.this.mapChanged = false;
                }
                this.allmsg = tankgameServer.this.messageBox.getAll();
                int nbrmsg = this.allmsg.length;
                tankgameServer.this.messageBox.clear();
                i2 = 0;
                while (i2 < 6) {
                    if (tankgameServer.this.th[i2] != null && tankgameServer.this.th[i2].running) {
                        int sendTanks = 0;
                        try {
                            tankgameServer.this.th[i2].output.write(tankgame.numTanks);
                            int a = 0;
                            while (a < 6) {
                                if (tankgameServer.this.tank[a] != null && tankgameServer.this.tank[a].running) {
                                    if (sendTanks < tankgame.numTanks) {
                                        tankgameServer.this.sendTankinfo(a, tankgameServer.this.th[i2].output);
                                    }
                                    ++sendTanks;
                                }
                                ++a;
                            }
                            tankgameServer.this.th[i2].output.write(nbrmsg);
                            int n = 0;
                            while (n < nbrmsg) {
                                tankgameServer.this.th[i2].output.write(this.allmsg[n].length());
                                tankgameServer.this.th[i2].output.write(this.allmsg[n].getBytes());
                                ++n;
                            }
                            tankgameServer.this.th[i2].output.flush();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    ++i2;
                }
                int i4 = 0;
                while (i4 < 6) {
                    if (tankgameServer.this.tank[i4] != null && tankgameServer.this.tank[i4].running && tankgameServer.this.tank[i4].kill) {
                        tankgameServer.this.tank[i4].kill = false;
                    }
                    if (tankgameServer.this.nameChanged[i4]) {
                        tankgameServer.this.nameChanged[i4] = false;
                    }
                    if (tankgameServer.this.pointed[i4]) {
                        tankgameServer.this.pointed[i4] = false;
                    }
                    ++i4;
                }
                try {
                    tankgameServerPoster.sleep(50L);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            try {
                i = 0;
                while (i < 6) {
                    if (tankgameServer.this.th[i] != null) {
                        tankgameServer.this.th[i].running = false;
                        tankgameServer.this.th[i].input.close();
                        System.out.println("sending close command to #" + i);
                        tankgameServer.this.th[i].output.write(255);
                        tankgameServer.this.th[i].output.close();
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            System.exit(0);
        }
    }
}

