/*
 * Decompiled with CFR 0.152.
 */
package tankowar;

class TimedMessageQueue {
    String[] messages;
    int[] ttl;
    int validTicks;

    public TimedMessageQueue(int size, int ticks) {
        this.messages = new String[size];
        this.ttl = new int[size];
        this.validTicks = ticks;
    }

    public void add(String message) {
        int i = this.messages.length - 2;
        while (i >= 0) {
            this.messages[i + 1] = this.messages[i];
            this.ttl[i + 1] = this.ttl[i];
            --i;
        }
        this.messages[0] = message;
        this.ttl[0] = this.validTicks;
    }

    public void clear() {
        int i = 0;
        while (i < this.messages.length) {
            this.messages[i] = null;
            ++i;
        }
    }

    public void debugPrint() {
        int i = 0;
        while (i < this.messages.length) {
            System.out.println(i + "   " + this.messages[i]);
            ++i;
        }
    }

    public String[] getAll() {
        int count = this.nbrItemsInQueue();
        String[] result = new String[count];
        int i = 0;
        while (i < count) {
            result[i] = this.messages[i];
            ++i;
        }
        return result;
    }

    public int nbrItemsInQueue() {
        int i = 0;
        while (i < this.messages.length) {
            if (this.messages[i] == null) {
                return i;
            }
            ++i;
        }
        return this.messages.length;
    }

    public String remove() {
        int i = this.messages.length - 1;
        while (i >= 0) {
            if (this.messages[i] != null) {
                String tmp = this.messages[i];
                this.messages[i] = null;
                return tmp;
            }
            --i;
        }
        return null;
    }

    public void tick() {
        int i = 0;
        while (i < this.messages.length) {
            int n = i;
            this.ttl[n] = this.ttl[n] - 1;
            if (this.ttl[i] == 0) {
                this.messages[i] = null;
            }
            ++i;
        }
    }
}

