/*
 * Decompiled with CFR 0.152.
 */
package tankowar;

import java.awt.Color;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import tankowar.TimedMessageQueue;

class tankgame
extends Frame {
    static String VERSION = "v1.1b";
    int actTank;
    int[] deaths;
    Flag flag = null;
    int gamemode;
    Hill hill = null;
    Image[] imColor = new Image[6];
    Image imFlag;
    Image imGras;
    Image imGras2;
    Image imGras3;
    Image imPavement;
    Image imTank;
    Image imTankBurning;
    Image imWall;
    Image imWater;
    Image imWater2;
    Image imWater3;
    int[] kills;
    Map map = new Map();
    String mapname;
    TimedMessageQueue messageBox;
    static int numTanks;
    Image offscreenIm;
    Graphics og;
    int[] points;
    boolean sendFlag = false;
    boolean showStats;
    boolean start;
    Tank[] tank = new Tank[6];
    String[] tankname = new String[6];

    public tankgame() {
        numTanks = 0;
        this.createColorCodes();
        this.getToolkit();
        this.imTank = Toolkit.getDefaultToolkit().getImage("pictures/quikndirty.gif");
        this.getToolkit();
        this.imTankBurning = Toolkit.getDefaultToolkit().getImage("pictures/quikndirtyburning.gif");
        this.getToolkit();
        this.imFlag = Toolkit.getDefaultToolkit().getImage("pictures/flag.gif");
        this.getToolkit();
        this.imGras = Toolkit.getDefaultToolkit().getImage("pictures/gras.jpg");
        this.getToolkit();
        this.imGras2 = Toolkit.getDefaultToolkit().getImage("pictures/gras2.jpg");
        this.getToolkit();
        this.imGras3 = Toolkit.getDefaultToolkit().getImage("pictures/gras3.jpg");
        this.getToolkit();
        this.imWater = Toolkit.getDefaultToolkit().getImage("pictures/water.jpg");
        this.getToolkit();
        this.imWater2 = Toolkit.getDefaultToolkit().getImage("pictures/water2.jpg");
        this.getToolkit();
        this.imWater3 = Toolkit.getDefaultToolkit().getImage("pictures/water3.jpg");
        this.getToolkit();
        this.imPavement = Toolkit.getDefaultToolkit().getImage("pictures/pavement.jpg");
        this.getToolkit();
        this.imWall = Toolkit.getDefaultToolkit().getImage("pictures/wall.jpg");
        MediaTracker mt = new MediaTracker(this);
        mt.addImage(this.imTank, 0);
        mt.addImage(this.imTankBurning, 1);
        mt.addImage(this.imGras, 2);
        mt.addImage(this.imWater, 3);
        mt.addImage(this.imPavement, 4);
        mt.addImage(this.imWall, 5);
        mt.addImage(this.imWater2, 6);
        mt.addImage(this.imWater3, 7);
        mt.addImage(this.imGras2, 8);
        mt.addImage(this.imGras3, 9);
        try {
            mt.waitForAll();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.setTitle("Tank 'O' War   " + VERSION);
        this.setSize(800, 600);
        this.setVisible(true);
        this.setResizable(false);
        new UpdateTimer(this);
        this.start = true;
    }

    private void createColorCodes() {
        int i = 0;
        while (i < 6) {
            this.imColor[i] = new BufferedImage(36, 36, 2);
            Graphics g = this.imColor[i].getGraphics();
            switch (i) {
                case 0: {
                    g.setColor(Color.RED);
                    break;
                }
                case 1: {
                    g.setColor(Color.BLACK);
                    break;
                }
                case 2: {
                    g.setColor(Color.ORANGE);
                    break;
                }
                case 3: {
                    g.setColor(Color.WHITE);
                    break;
                }
                case 4: {
                    g.setColor(Color.YELLOW);
                    break;
                }
                case 5: {
                    g.setColor(Color.CYAN);
                }
            }
            this.drawColorShape(g);
            ++i;
        }
    }

    private void drawColorShape(Graphics g) {
        g.drawLine(24, 17, 25, 16);
        g.drawLine(25, 16, 27, 18);
        g.drawLine(24, 21, 25, 20);
        g.drawLine(25, 20, 27, 22);
        g.drawLine(24, 25, 25, 24);
        g.drawLine(25, 24, 27, 26);
        g.drawLine(17, 29, 14, 32);
        g.drawLine(17, 29, 20, 32);
        g.drawLine(17, 30, 15, 32);
        g.drawLine(17, 30, 19, 32);
    }

    public void paint(Graphics g) {
        if (this.start) {
            this.map.draw(g);
            Graphics2D g2 = (Graphics2D)g;
            int i = 0;
            while (i < 6) {
                if (this.tank[i] != null && this.tank[i].running) {
                    this.tank[i].draw(g2);
                }
                ++i;
            }
            if (this.gamemode == 2) {
                this.hill.draw(g2);
            } else if (this.gamemode == 1) {
                this.flag.draw(g2);
            }
            g2.setColor(Color.ORANGE);
            if (this.showStats) {
                int y = 100;
                g2.drawString("Name", 100, y);
                g2.drawString("Kills Deaths Points", 260, y);
                g2.drawString("-----------------------------------------------------------------", 100, y += 20);
                int i2 = 0;
                while (i2 < 6) {
                    if (this.tank[i2] != null && this.tank[i2].running) {
                        y += 20;
                        switch (i2) {
                            case 0: {
                                g2.setColor(Color.RED);
                                break;
                            }
                            case 1: {
                                g2.setColor(Color.BLACK);
                                break;
                            }
                            case 2: {
                                g2.setColor(Color.ORANGE);
                                break;
                            }
                            case 3: {
                                g2.setColor(Color.WHITE);
                                break;
                            }
                            case 4: {
                                g2.setColor(Color.YELLOW);
                                break;
                            }
                            case 5: {
                                g2.setColor(Color.CYAN);
                            }
                        }
                        g2.fillOval(85, y - 10, 10, 10);
                        g2.setColor(Color.orange);
                        g2.drawString(this.tankname[i2], 100, y);
                        g2.drawString("  " + this.kills[i2] + "          " + this.deaths[i2] + "          " + this.points[i2], 260, y);
                    }
                    ++i2;
                }
                g2.drawString("(c)'05 by www.normanfreak.de.vu", 120, 300);
            }
        }
    }

    public void update(Graphics g) {
        if (this.offscreenIm == null) {
            this.offscreenIm = this.createImage(this.getSize().width, this.getSize().height);
        }
        this.og = this.offscreenIm.getGraphics();
        this.paint(this.og);
        this.og.dispose();
        g.drawImage(this.offscreenIm, 0, 0, null);
    }

    class Map {
        static final int GRAS = 0;
        static final int PAVEMENT = 1;
        static final int SQUARESIZE = 40;
        static final int WALL = 3;
        static final int WATER = 2;
        int height = 15;
        int[][] map = new int[this.width][this.height];
        String name;
        int width = 20;

        public void draw(Graphics g) {
            int x = 0;
            while (x < this.width) {
                int y = 0;
                while (y < this.height) {
                    switch (this.map[x][y]) {
                        case 0: {
                            int art = (x + 1) * (y + 2) * 4 % 3;
                            if (art == 0) {
                                g.drawImage(tankgame.this.imGras, x * 40, y * 40, null);
                                break;
                            }
                            if (art == 1) {
                                g.drawImage(tankgame.this.imGras2, x * 40, y * 40, null);
                                break;
                            }
                            g.drawImage(tankgame.this.imGras3, x * 40, y * 40, null);
                            break;
                        }
                        case 1: {
                            g.drawImage(tankgame.this.imPavement, x * 40, y * 40, null);
                            break;
                        }
                        case 3: {
                            g.drawImage(tankgame.this.imWall, x * 40, y * 40, null);
                            break;
                        }
                        case 2: {
                            int art = (x + 1) * (y + 1) % 3;
                            if (art == 0) {
                                g.drawImage(tankgame.this.imWater, x * 40, y * 40, null);
                                break;
                            }
                            if (art == 1) {
                                g.drawImage(tankgame.this.imWater2, x * 40, y * 40, null);
                                break;
                            }
                            g.drawImage(tankgame.this.imWater3, x * 40, y * 40, null);
                        }
                    }
                    ++y;
                }
                ++x;
            }
        }

        public boolean makeMap(String file) {
            String oldname = this.name;
            this.name = file;
            file = "maps/" + file + ".map";
            try {
                File fcheck = new File(file);
                if (!fcheck.exists()) {
                    this.name = oldname;
                    return false;
                }
                System.out.println("loading map " + this.name);
                FileInputStream fs = new FileInputStream(file);
                int y = 0;
                while (y < this.height) {
                    int x = 0;
                    while (x < this.width) {
                        int field;
                        this.map[x][y] = field = fs.read() - 48;
                        ++x;
                    }
                    ++y;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
            return true;
        }

        private void makeTestmap() {
            int x = 0;
            while (x < this.width) {
                int y = 0;
                while (y < this.height) {
                    this.map[x][y] = (int)(Math.random() * 4.0);
                    ++y;
                }
                ++x;
            }
        }

        public void saveMap() {
            String file = "maps/" + this.name + ".map";
            try {
                FileOutputStream fs = new FileOutputStream(file);
                int y = 0;
                while (y < this.height) {
                    int x = 0;
                    while (x < this.width) {
                        fs.write(this.map[x][y] + 48);
                        ++x;
                    }
                    ++y;
                }
                fs.close();
                System.out.println(" saved map " + this.name);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    class Bullet
    extends Thread {
        Tank owner;
        boolean running;
        SpeedVector sv;
        double x;
        double y;

        public Bullet(double x, double y, double angle, Tank tank) {
            this.x = x;
            this.y = y;
            this.sv = new SpeedVector(angle);
            this.sv.accelerate(12.0f);
            this.owner = tank;
            this.running = true;
        }

        public void draw(Graphics g) {
            if (this.running) {
                g.setColor(Color.red);
                g.drawLine((int)this.x, (int)this.y, (int)(this.x + (double)this.sv.x), (int)(this.y + (double)this.sv.y));
            }
        }

        public void move() {
            block10: {
                block9: {
                    this.x += (double)this.sv.x;
                    this.y += (double)this.sv.y;
                    if (this.x < 0.0) break block9;
                    Map cfr_ignored_0 = tankgame.this.map;
                    if (this.x > (double)(tankgame.this.map.width * 40) || this.y < 0.0) break block9;
                    Map cfr_ignored_1 = tankgame.this.map;
                    if (!(this.y > (double)(tankgame.this.map.height * 40))) break block10;
                }
                this.running = false;
                return;
            }
            int i = 0;
            while (i < 6) {
                Rectangle rect;
                if (tankgame.this.tank[i] != null && tankgame.this.tank[i].running && (rect = new Rectangle((int)tankgame.this.tank[i].x + 2, (int)tankgame.this.tank[i].y + 2, 34, 34)).contains(this.x, this.y)) {
                    this.running = false;
                    if (tankgame.this.tank[i].alive) {
                        tankgame.this.tank[i].destroy();
                        int n = i;
                        tankgame.this.deaths[n] = tankgame.this.deaths[n] + 1;
                        this.owner.kill = true;
                        int n2 = 0;
                        while (n2 < 6) {
                            if (tankgame.this.tank[n2] != null && tankgame.this.tank[n2] == this.owner) {
                                tankgame.this.messageBox.add(new String(tankgame.this.tankname[n2] + " killed " + tankgame.this.tankname[i]));
                            }
                            ++n2;
                        }
                    }
                    return;
                }
                ++i;
            }
            Map cfr_ignored_2 = tankgame.this.map;
            Map cfr_ignored_3 = tankgame.this.map;
            if (tankgame.this.map.map[(int)(this.x / 40.0)][(int)(this.y / 40.0)] == 3) {
                this.running = false;
            }
        }

        public void run() {
            while (this.running) {
                try {
                    Bullet.sleep(100L);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                this.move();
                tankgame.this.repaint();
            }
        }

        public void set(double x, double y, double angle) {
            this.x = x;
            this.y = y;
            this.sv.angle = angle;
            this.sv.setXY();
        }
    }

    class SpeedVector {
        double angle;
        float speed = 0.0f;
        float x;
        float y;

        public SpeedVector(double startAngle) {
            this.angle = startAngle;
            this.setXY();
        }

        public void accelerate(float acc) {
            this.speed += acc;
            this.setXY();
        }

        private void setXY() {
            this.x = (float)((double)this.speed * Math.cos(this.angle));
            this.y = (float)((double)this.speed * Math.sin(this.angle));
        }

        public void turn(double turn) {
            this.angle += turn;
            this.setXY();
        }
    }

    class Tank {
        boolean alive;
        Bullet[] bullet;
        double direction;
        Image imColorCode;
        boolean kill;
        long lastFiretime;
        boolean running = true;
        double x;
        double y;

        public Tank(int xpos, int ypos, double dir) {
            this.set(xpos, ypos, dir);
            this.bullet = new Bullet[6];
            this.alive = true;
        }

        public Tank() {
            this.bullet = new Bullet[6];
            this.reborn();
        }

        public void destroy() {
            this.alive = false;
            if (tankgame.this.gamemode == 1 && tankgame.this.flag.owner == this) {
                tankgame.this.flag.set((int)this.x, (int)this.y, null);
                tankgame.this.sendFlag = true;
            }
        }

        public void draw(Graphics2D g2) {
            AffineTransform at = new AffineTransform();
            at.setToRotation(this.direction + 1.5707963267948966, 18.0 + this.x, 18.0 + this.y);
            at.translate(this.x, this.y);
            if (this.alive) {
                g2.drawImage(tankgame.this.imTank, at, null);
            } else {
                g2.drawImage(tankgame.this.imTankBurning, at, null);
            }
            g2.drawImage(this.imColorCode, at, null);
            int i = 0;
            while (i < 6) {
                if (this.bullet[i] != null) {
                    this.bullet[i].draw(g2);
                }
                ++i;
            }
        }

        private void findPos() {
            do {
                this.x = (int)((double)tankgame.this.map.width * Math.random());
                this.y = (int)((double)tankgame.this.map.height * Math.random());
                Map cfr_ignored_0 = tankgame.this.map;
            } while (tankgame.this.map.map[(int)this.x][(int)this.y] > 1);
            Map cfr_ignored_1 = tankgame.this.map;
            this.x *= 40.0;
            Map cfr_ignored_2 = tankgame.this.map;
            this.y *= 40.0;
        }

        public void fire() {
            if (this.alive) {
                if (System.currentTimeMillis() - this.lastFiretime < 2000L) {
                    return;
                }
                int bulletNbr = this.getFreeBulletSlot();
                if (bulletNbr == -1) {
                    System.out.println("no free bullet");
                    return;
                }
                double bulletx = this.x + 18.0 + 18.0 * Math.cos(this.direction);
                double bullety = this.y + 18.0 + 18.0 * Math.sin(this.direction);
                this.bullet[bulletNbr] = new Bullet(bulletx, bullety, this.direction, this);
                this.bullet[bulletNbr].start();
                this.lastFiretime = System.currentTimeMillis();
            }
        }

        private int getFreeBulletSlot() {
            int i = 0;
            while (i < 6) {
                if (this.bullet[i] == null) {
                    return i;
                }
                if (!this.bullet[i].running) {
                    return i;
                }
                ++i;
            }
            return -1;
        }

        public int getNbrBullets() {
            int nbr = 0;
            int i = 0;
            while (i < 6) {
                if (this.bullet[i] != null && this.bullet[i].running) {
                    ++nbr;
                }
                ++i;
            }
            return nbr;
        }

        public void move(double fb) {
            int lry;
            int lrx;
            int uly;
            int ulx;
            double dify;
            double difx;
            block11: {
                block10: {
                    if (!this.alive) {
                        return;
                    }
                    Map cfr_ignored_0 = tankgame.this.map;
                    Map cfr_ignored_1 = tankgame.this.map;
                    Map cfr_ignored_2 = tankgame.this.map;
                    if (tankgame.this.map.map[(int)(this.x + 18.0) / 40][(int)(this.y + 18.0) / 40] == 1) {
                        fb *= 1.6;
                    }
                    difx = Math.cos(this.direction) * fb;
                    dify = Math.sin(this.direction) * fb;
                    int newx = (int)(this.x + difx);
                    int newy = (int)(this.y + dify);
                    ulx = (int)((double)(newx + 2) + 4.0 * Math.abs(Math.sin(this.direction)));
                    uly = (int)((double)(newy + 2) + 4.0 * Math.abs(Math.cos(this.direction)));
                    lrx = (int)((double)(newx + 34) - 4.0 * Math.abs(Math.sin(this.direction)));
                    lry = (int)((double)(newy + 34) - 4.0 * Math.abs(Math.cos(this.direction)));
                    if (ulx < 0) break block10;
                    Map cfr_ignored_3 = tankgame.this.map;
                    if (lrx >= tankgame.this.map.width * 40 || uly < 0) break block10;
                    Map cfr_ignored_4 = tankgame.this.map;
                    if (lry < tankgame.this.map.height * 40) break block11;
                }
                return;
            }
            Map cfr_ignored_5 = tankgame.this.map;
            Map cfr_ignored_6 = tankgame.this.map;
            Map cfr_ignored_7 = tankgame.this.map;
            if (tankgame.this.map.map[ulx / 40][uly / 40] > 1) {
                return;
            }
            Map cfr_ignored_8 = tankgame.this.map;
            Map cfr_ignored_9 = tankgame.this.map;
            Map cfr_ignored_10 = tankgame.this.map;
            if (tankgame.this.map.map[lrx / 40][lry / 40] > 1) {
                return;
            }
            Map cfr_ignored_11 = tankgame.this.map;
            Map cfr_ignored_12 = tankgame.this.map;
            Map cfr_ignored_13 = tankgame.this.map;
            if (tankgame.this.map.map[lrx / 40][uly / 40] > 1) {
                return;
            }
            Map cfr_ignored_14 = tankgame.this.map;
            Map cfr_ignored_15 = tankgame.this.map;
            Map cfr_ignored_16 = tankgame.this.map;
            if (tankgame.this.map.map[ulx / 40][lry / 40] > 1) {
                return;
            }
            if (tankgame.this.gamemode == 1 && tankgame.this.flag.inside((int)this.x + 18, (int)this.y + 18)) {
                tankgame.this.flag.owner = this;
                tankgame.this.sendFlag = true;
            }
            this.x += difx;
            this.y += dify;
        }

        public void reborn() {
            this.direction = 0.0;
            this.findPos();
            this.alive = true;
            this.kill = false;
            this.lastFiretime = System.currentTimeMillis();
        }

        public void set(int xpos, int ypos, double dir) {
            this.direction = dir;
            this.x = xpos;
            this.y = ypos;
        }

        public void setColorCode(int num) {
            if (num > 5) {
                return;
            }
            this.imColorCode = tankgame.this.imColor[num];
        }

        public void turn(double lr) {
            if (this.alive) {
                this.direction += lr;
                if (this.direction < 0.0) {
                    this.direction = Math.PI * 2 + this.direction;
                }
                if (this.direction > Math.PI * 2) {
                    this.direction -= Math.PI * 2;
                }
            }
        }
    }

    class UpdateTimer
    extends Thread {
        tankgame client;
        boolean running;

        public UpdateTimer(tankgame myclient) {
            this.client = myclient;
            this.running = true;
        }

        public void run() {
            while (this.running) {
                try {
                    UpdateTimer.sleep(10L);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                this.client.repaint();
            }
        }
    }

    static class GAMEMODE {
        static final int CTF = 1;
        static final int DEATHMATCH = 0;
        static final int KOTH = 2;
        static final int TEAMMODE = 3;

        GAMEMODE() {
        }
    }

    class Hill {
        Ellipse2D.Float circle;
        int x;
        int y;

        public Hill(int _x, int _y) {
            this.x = _x;
            this.y = _y;
            this.circle = new Ellipse2D.Float(this.x, this.y, 120.0f, 120.0f);
        }

        public Hill() {
            this.x = (int)(10.0 * Math.random() + 5.0) * 40;
            this.y = (int)(10.0 * Math.random() + 3.0) * 40;
            this.circle = new Ellipse2D.Float(this.x, this.y, 120.0f, 120.0f);
        }

        public void draw(Graphics g) {
            g.setColor(Color.RED);
            g.drawOval(this.x, this.y, 120, 120);
            g.drawOval(this.x + 2, this.y + 2, 116, 116);
        }

        public boolean inside(Tank tank) {
            return this.circle.contains(tank.x + 18.0, tank.y + 18.0);
        }
    }

    class Flag {
        Tank owner;
        Rectangle rect;
        int x;
        int y;

        public Flag(int _x, int _y, Tank _owner) {
            this.x = _x;
            this.y = _y;
            this.rect = new Rectangle(this.x, this.y, 18, 21);
            this.owner = _owner;
        }

        public Flag() {
            this.findPos();
            this.rect = new Rectangle(this.x, this.y, 18, 21);
            this.owner = null;
        }

        public boolean checkOwner(Tank tank) {
            return this.owner == tank;
        }

        public void draw(Graphics g) {
            if (this.owner == null) {
                g.drawImage(tankgame.this.imFlag, this.x, this.y, null);
            } else {
                g.drawImage(tankgame.this.imFlag, (int)this.owner.x + 9, (int)this.owner.y + 9, null);
            }
        }

        private void findPos() {
            do {
                this.x = (int)(16.0 * Math.random()) + 2;
                this.y = (int)(11.0 * Math.random()) + 2;
                Map cfr_ignored_0 = tankgame.this.map;
            } while (tankgame.this.map.map[this.x][this.y] > 1);
            Map cfr_ignored_1 = tankgame.this.map;
            this.x *= 40 + 8;
            Map cfr_ignored_2 = tankgame.this.map;
            this.y *= 40 + 8;
        }

        public boolean inside(int _x, int _y) {
            if (this.owner != null) {
                return false;
            }
            return this.rect.contains(_x, _y);
        }

        public void set(int _x, int _y, Tank tank) {
            this.x = _x;
            this.y = _y;
            this.owner = tank;
            this.rect.setBounds(_x, _y, 18, 21);
        }
    }
}

