/*
 * Decompiled with CFR 0.152.
 */
package tankowar;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import tankowar.OwnWindowAdapter;
import tankowar.TimedMessageQueue;
import tankowar.tankgame;

class tankgameClient
extends tankgame
implements KeyListener,
ActionListener {
    boolean[] bulletIsActive;
    byte[] bulletmsg;
    byte[] bullets;
    Socket client;
    tankgameClientReader clientReader;
    boolean down;
    boolean fire;
    byte[] flagmsg;
    InputStream input;
    String ip = "192.168.120.254";
    private int lastNumTanks = 0;
    long lastTimeFired;
    boolean left;
    static boolean mainRunning = true;
    int maxPlayers;
    byte[] msg = new byte[8];
    String msgChat = "";
    String msgConsole = "";
    OutputStream output;
    boolean readChat;
    boolean readConsole;
    boolean restart;
    boolean right;
    boolean running;
    static boolean serverDisconnected = false;
    JFrame startSplash;
    JTextField txtHostname;
    JTextField txtPlayername;
    boolean up;

    public tankgameClient(String newip) {
        this.bulletmsg = new byte[7];
        this.bullets = new byte[1];
        this.flagmsg = new byte[5];
        this.bulletIsActive = new boolean[6];
        this.ip = newip;
        this.restart = false;
        this.fire = false;
        this.down = false;
        this.up = false;
        this.right = false;
        this.left = false;
        this.showStats = false;
        this.readChat = false;
        this.readConsole = false;
        this.messageBox = new TimedMessageQueue(6, 120);
        this.addWindowListener(new OwnWindowAdapter(this));
        this.createStartSplash();
        this.repaint();
    }

    public void actionPerformed(ActionEvent ae) {
        String ac = ae.getActionCommand();
        if (ac.equalsIgnoreCase("connect")) {
            this.connectToHost();
        }
    }

    private void connectToHost() {
        if (this.txtHostname.getText().length() > 0) {
            this.ip = this.txtHostname.getText();
        }
        System.out.println(" trying to connect to " + this.ip);
        try {
            this.client = new Socket(this.ip, 1111);
            this.input = this.client.getInputStream();
            this.output = this.client.getOutputStream();
            this.client.setTcpNoDelay(true);
            this.readGamemode();
            this.negotiateMap();
            this.sendName(this.txtPlayername.getText());
            this.actTank = this.input.read();
            tankgame.numTanks = this.input.read();
            this.maxPlayers = this.input.read();
            this.deaths = new int[this.maxPlayers];
            this.kills = new int[this.maxPlayers];
            this.points = new int[this.maxPlayers];
            System.out.println(" connected to Server at " + this.ip + " as #" + this.actTank + " with name " + this.txtPlayername.getText());
            System.out.println(" currently " + tankgame.numTanks + " people playing");
            int i = 0;
            while (i < tankgame.numTanks) {
                this.receiveData(false);
                ++i;
            }
            this.running = true;
        }
        catch (Exception e) {
            System.out.println("unable to connect to host");
            return;
        }
        serverDisconnected = false;
        this.addKeyListener(this);
        this.clientReader = new tankgameClientReader(this);
        this.clientReader.start();
        this.startSplash.hide();
        this.startSplash = null;
        this.repaint();
    }

    private void createStartSplash() {
        this.startSplash = new JFrame("Enter IP or name of gamehost");
        this.startSplash.setResizable(false);
        JLabel lblName = new JLabel("Playername:");
        JLabel lblHost = new JLabel("   Gamehost:");
        this.txtPlayername = new JTextField("Player");
        this.txtPlayername.setPreferredSize(new Dimension(180, 25));
        this.txtHostname = new JTextField();
        this.txtHostname.setPreferredSize(new Dimension(180, 25));
        JPanel panel = new JPanel();
        JButton btnGo = new JButton("connect");
        btnGo.setActionCommand("connect");
        btnGo.setPreferredSize(new Dimension(80, 25));
        btnGo.addActionListener(this);
        panel.add(lblName);
        panel.add(this.txtPlayername);
        panel.add(lblHost);
        panel.add(this.txtHostname);
        panel.add(btnGo);
        this.startSplash.getContentPane().add(panel);
        this.startSplash.doLayout();
        this.startSplash.pack();
        this.startSplash.repaint();
        this.startSplash.setSize(300, 130);
        this.startSplash.show();
    }

    public void keyPressed(KeyEvent e) {
        if (this.readConsole || this.readChat) {
            return;
        }
        int key = e.getKeyCode();
        if (key == 38) {
            this.up = true;
        } else if (key == 40) {
            this.down = true;
        }
        if (key == 37) {
            this.left = true;
        } else if (key == 39) {
            this.right = true;
        }
        if (key == 32) {
            this.fire = true;
        }
        if (key == 83 && !this.tank[this.actTank].alive) {
            this.restart = true;
        }
        if (key == 112) {
            this.showStats = true;
        }
    }

    public void keyReleased(KeyEvent e) {
        int key = e.getKeyCode();
        if (key == 38) {
            this.up = false;
        } else if (key == 40) {
            this.down = false;
        }
        if (key == 37) {
            this.left = false;
        } else if (key == 39) {
            this.right = false;
        }
        if (key == 32) {
            this.fire = false;
        }
        if (key == 83) {
            this.restart = false;
        }
        if (key == 112) {
            this.showStats = false;
        }
        if (key == 17) {
            this.msgConsole = "";
            this.readConsole = true;
            return;
        }
        if (key == 10) {
            if (this.readConsole) {
                this.readConsole = false;
                try {
                    this.output.write(15);
                    this.output.write(this.msgConsole.length());
                    this.output.write(this.msgConsole.getBytes());
                    this.output.flush();
                }
                catch (Exception exc) {
                    exc.printStackTrace();
                }
            } else if (this.readChat) {
                this.readChat = false;
                try {
                    this.output.write(16);
                    this.output.write(this.msgChat.length());
                    this.output.write(this.msgChat.getBytes());
                    this.output.flush();
                }
                catch (Exception exc) {
                    exc.printStackTrace();
                }
            } else {
                this.msgChat = "";
                this.readChat = true;
            }
        } else if (this.readConsole) {
            this.msgConsole = e.getKeyCode() == 8 ? this.msgConsole.substring(0, this.msgConsole.length() - 1) : this.msgConsole + e.getKeyChar();
        } else if (this.readChat) {
            this.msgChat = e.getKeyCode() == 8 ? this.msgChat.substring(0, this.msgChat.length() - 1) : this.msgChat + e.getKeyChar();
        }
    }

    public void keyTyped(KeyEvent e) {
    }

    /*
     * Unable to fully structure code
     */
    public static void main(String[] args) {
        ip = "127.0.0.1";
        if (args.length >= 1) {
            ip = args[0];
        }
        client = new tankgameClient(ip);
        ** GOTO lbl18
        {
            try {
                client.sendData();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            do {
                if (!client.running) continue;
                if (client.clientReader.running) continue block2;
lbl18:
                // 3 sources

            } while (tankgameClient.mainRunning);
        }
    }

    private void negotiateMap() throws Exception {
        int size = this.input.read();
        byte[] buffer = new byte[size];
        this.input.read(buffer);
        String mapname = new String(buffer);
        System.out.println("new map '" + mapname + "'");
        if (this.map.makeMap(mapname)) {
            this.output.write(0);
            this.output.flush();
        } else {
            this.output.write(128);
            this.output.flush();
            byte[] mapdata = new byte[300];
            this.input.read(mapdata);
            int y = 0;
            while (y < 15) {
                int x = 0;
                while (x < 20) {
                    this.map.map[x][y] = mapdata[x + y * 20];
                    ++x;
                }
                ++y;
            }
            this.map.saveMap();
        }
    }

    public void paint(Graphics g) {
        super.paint(g);
        int time = (int)(System.currentTimeMillis() - this.lastTimeFired);
        if (time >= 2000) {
            g.setColor(Color.GREEN);
            g.fill3DRect(650, 40, 100, 20, true);
            g.setColor(Color.WHITE);
            g.drawString("Loaded", 670, 55);
        } else {
            g.setColor(Color.RED);
            g.draw3DRect(650, 40, 100, 20, true);
            g.fill3DRect(650, 40, time / 20, 20, true);
            g.setColor(Color.WHITE);
            g.drawString("Loading...", 670, 55);
        }
        if (serverDisconnected) {
            g.drawString(" Server was shutdown!", 300, 200);
        }
        if (this.readConsole) {
            g.drawString("$> " + this.msgConsole, 30, 580);
        }
        if (this.readChat) {
            g.drawString(">> " + this.msgChat, 30, 580);
        }
        if (this.messageBox == null) {
            return;
        }
        int i = 0;
        while (i < this.messageBox.nbrItemsInQueue()) {
            g.drawString(this.messageBox.messages[i], 30, 55 + i * 12);
            ++i;
        }
    }

    private void readGamemode() throws Exception {
        this.gamemode = this.input.read();
        switch (this.gamemode) {
            case 0: {
                this.hill = null;
                this.flag = null;
                break;
            }
            case 2: {
                this.flag = null;
                byte[] modeMsg = new byte[4];
                this.input.read(modeMsg);
                int x = modeMsg[1] < 0 ? (modeMsg[0] << 8) + modeMsg[1] + 256 : (modeMsg[0] << 8) + modeMsg[1];
                int y = modeMsg[3] < 0 ? (modeMsg[2] << 8) + modeMsg[3] + 256 : (modeMsg[2] << 8) + modeMsg[3];
                this.hill = new tankgame.Hill(x, y);
                break;
            }
            case 1: {
                this.hill = null;
                byte[] modeMsg = new byte[5];
                this.input.read(modeMsg);
                int x = modeMsg[1] < 0 ? (modeMsg[0] << 8) + modeMsg[1] + 256 : (modeMsg[0] << 8) + modeMsg[1];
                int y = modeMsg[3] < 0 ? (modeMsg[2] << 8) + modeMsg[3] + 256 : (modeMsg[2] << 8) + modeMsg[3];
                this.flag = modeMsg[4] >= 0 ? new tankgame.Flag(x, y, this.tank[modeMsg[4]]) : new tankgame.Flag(x, y, null);
            }
        }
    }

    private void receiveAllData() throws Exception {
        int i;
        tankgame.numTanks = this.input.read();
        if (tankgame.numTanks == -1) {
            System.out.println("Server shut down");
            serverDisconnected = true;
            this.running = false;
            this.clientReader.running = false;
            int i2 = 0;
            while (i2 < 6) {
                if (this.tank[i2] != null) {
                    this.tank[i2] = null;
                }
                ++i2;
            }
            this.createStartSplash();
            return;
        }
        if (tankgame.numTanks == 13) {
            this.negotiateMap();
            System.out.println(" changed map");
            return;
        }
        if (tankgame.numTanks == 14) {
            this.readGamemode();
            return;
        }
        if (tankgame.numTanks == 15) {
            this.receiveFlagdata();
            return;
        }
        if (this.lastNumTanks > tankgame.numTanks) {
            i = 0;
            while (i < 6) {
                if (this.tank[i] != null && this.tank[i].running) {
                    this.tank[i].running = false;
                }
                ++i;
            }
        }
        i = 0;
        while (i < tankgame.numTanks) {
            this.receiveData(this.lastNumTanks > tankgame.numTanks);
            ++i;
        }
        int nbrmsg = this.input.read();
        this.lastNumTanks = tankgame.numTanks;
        int i3 = 0;
        while (i3 < nbrmsg) {
            this.receiveMessage();
            ++i3;
        }
        this.repaint();
    }

    private void receiveData(boolean checkAlive) throws Exception {
        byte misc;
        this.input.read(this.msg);
        byte thisTank = this.msg[0];
        int xpos = this.msg[2] < 0 ? (this.msg[1] << 8) + this.msg[2] + 256 : (this.msg[1] << 8) + this.msg[2];
        int ypos = this.msg[4] < 0 ? (this.msg[3] << 8) + this.msg[4] + 256 : (this.msg[3] << 8) + this.msg[4];
        int dir = this.msg[6] < 0 ? (this.msg[5] << 8) + this.msg[6] + 256 : (this.msg[5] << 8) + this.msg[6];
        double direction = (double)dir / 1000.0;
        if (this.tank[thisTank] == null) {
            this.tank[thisTank] = new tankgame.Tank(xpos, ypos, direction);
            this.tank[thisTank].setColorCode(thisTank);
            this.kills[thisTank] = 0;
            this.deaths[thisTank] = 0;
            this.points[thisTank] = 0;
        } else {
            this.tank[thisTank].set(xpos, ypos, direction);
        }
        if (checkAlive) {
            this.tank[thisTank].running = true;
        }
        if (((misc = this.msg[7]) & 1) == 0) {
            if (this.tank[thisTank].alive) {
                this.tank[thisTank].destroy();
                byte by = thisTank;
                this.deaths[by] = this.deaths[by] + 1;
            }
        } else if (!this.tank[thisTank].alive) {
            this.tank[thisTank].alive = true;
        }
        if ((misc & 0x10) > 0) {
            byte by = thisTank;
            this.points[by] = this.points[by] + 1;
        }
        if ((misc & 4) > 0) {
            byte by = thisTank;
            this.kills[by] = this.kills[by] + 1;
        }
        int i = 0;
        while (i < 6) {
            this.bulletIsActive[i] = false;
            ++i;
        }
        if ((misc & 2) > 0) {
            this.input.read(this.bullets);
            int nbrBullets = this.bullets[0];
            int i2 = 0;
            while (i2 < nbrBullets) {
                this.input.read(this.bulletmsg);
                xpos = this.bulletmsg[1] < 0 ? (this.bulletmsg[0] << 8) + this.bulletmsg[1] + 256 : (this.bulletmsg[0] << 8) + this.bulletmsg[1];
                ypos = this.bulletmsg[3] < 0 ? (this.bulletmsg[2] << 8) + this.bulletmsg[3] + 256 : (this.bulletmsg[2] << 8) + this.bulletmsg[3];
                dir = this.bulletmsg[5] < 0 ? (this.bulletmsg[4] << 8) + this.bulletmsg[5] + 256 : (this.bulletmsg[4] << 8) + this.bulletmsg[5];
                direction = (double)dir / 1000.0;
                this.bulletIsActive[this.bulletmsg[6]] = true;
                if (this.tank[thisTank].bullet[this.bulletmsg[6]] == null) {
                    this.tank[thisTank].bullet[this.bulletmsg[6]] = new tankgame.Bullet(xpos, ypos, direction, this.tank[thisTank]);
                } else {
                    this.tank[thisTank].bullet[this.bulletmsg[6]].set(xpos, ypos, direction);
                    if (!this.tank[thisTank].bullet[this.bulletmsg[6]].running) {
                        this.tank[thisTank].bullet[this.bulletmsg[6]].running = true;
                    }
                }
                ++i2;
            }
        }
        int i3 = 0;
        while (i3 < 6) {
            if (!this.bulletIsActive[i3] && this.tank[thisTank].bullet[i3] != null && this.tank[thisTank].bullet[i3].running) {
                this.tank[thisTank].bullet[i3].running = false;
            }
            ++i3;
        }
        if ((misc & 8) > 0) {
            byte[] namebuf = new byte[this.input.read()];
            this.input.read(namebuf);
            this.tankname[thisTank] = new String(namebuf);
            System.out.println("#" + thisTank + " changed name to " + this.tankname[thisTank]);
        }
    }

    private void receiveFlagdata() throws Exception {
        this.input.read(this.flagmsg);
        int x = this.flagmsg[1] < 0 ? (this.flagmsg[0] << 8) + this.flagmsg[1] + 256 : (this.flagmsg[0] << 8) + this.flagmsg[1];
        int y = this.flagmsg[3] < 0 ? (this.flagmsg[2] << 8) + this.flagmsg[3] + 256 : (this.flagmsg[2] << 8) + this.flagmsg[3];
        if (this.flagmsg[4] >= 0) {
            this.flag.set(x, y, this.tank[this.flagmsg[4]]);
        } else {
            this.flag.set(x, y, null);
        }
    }

    private void receiveMessage() throws Exception {
        byte[] stringbuf = new byte[this.input.read()];
        this.input.read(stringbuf);
        String message = new String(stringbuf);
        this.messageBox.add(message);
        System.out.println(message);
    }

    private synchronized void sendData() throws Exception {
        if (this.up) {
            this.output.write(1);
        }
        if (this.down) {
            this.output.write(2);
        }
        if (this.left) {
            this.output.write(4);
        }
        if (this.right) {
            this.output.write(3);
        }
        if (this.fire) {
            if (System.currentTimeMillis() - this.lastTimeFired >= 2000L) {
                this.lastTimeFired = System.currentTimeMillis();
            }
            this.output.write(5);
        }
        if (this.restart) {
            this.output.write(11);
        }
        this.output.flush();
        this.wait(100L);
        this.messageBox.tick();
    }

    private void sendName(String name) throws Exception {
        this.output.write(13);
        this.output.write(name.length());
        this.output.write(name.getBytes());
    }

    class tankgameClientReader
    extends Thread {
        tankgameClient client;
        boolean running;

        public tankgameClientReader(tankgameClient tgClient) {
            tankgameClient.this.lastTimeFired = System.currentTimeMillis() - 2000L;
            this.client = tgClient;
            this.running = true;
        }

        public void run() {
            while (this.running) {
                try {
                    this.client.receiveAllData();
                }
                catch (Exception exp) {
                    exp.printStackTrace();
                }
            }
        }
    }
}

